﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The practice.
    /// </summary>
    public class PracticeLocation
    { 
        /// <summary>
        /// Gets or sets the practice id.
        /// </summary>
        [Key, Identity]
        public int PracticeLocationId { get; set; }
        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; }
        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the practice type.
        /// </summary>
        public string Phone { get; set; }

        /// <summary>
        /// Gets or sets the tin.
        /// </summary>
        public string Extension { get; set; }
        /// <summary>
        /// Gets or sets the practice type.
        /// </summary>
        public string StreetAddress { get; set; }
        /// <summary>
        /// Gets or sets the practice type.
        /// </summary>
        public string AddressLine2 { get; set; }
        
        /// <summary>
        /// Gets or sets the tin.
        /// </summary>
        public string Zipcode { get; set; }
        /// <summary>
        /// Gets or sets the practice type.
        /// </summary>
        public int CountryId { get; set; }
        // <summary>
        /// Gets or sets the practice type.
        /// </summary>
        public int PracticeId { get; set; }
        // <summary>
        /// Gets or sets the practice type.
        /// </summary>
        public int? StateId { get; set; }
        // <summary>
        /// Gets or sets the practice type.
        /// </summary>
        public int? CityId { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the locationId.
        /// </summary>
        public int LocationId { get; set; }
    }
}
